#include "Proj3_aux.H"
#include <string>
#include <fstream>
#include <cstdlib>
#include "Concordance.H"

// process the command line
// modifies:  theFile
void getCmdLine ( int argc , char * argv [] , ifstream & theFile ) {
   if ( argc != 2 ) {
      // invalid number of arguments -- abort
      cerr << "Malformed command line. " << endl ;
      cerr << "Syntax:  " << argv [ 0 ] << " filename " << endl ;
      exit ( -1 ) ;
   }

   // ensure file can be opened & open it
   theFile . open ( argv [ 1 ] , ios::in ) ;
   if ( ! theFile ) {
      cerr << "Unable to open file " << argv [ 1 ] << endl ;
      cerr << "Program aborting." << endl ;
      exit ( -1 ) ;
   }
}


// handle commands
// returns:   nothing
// modifies:  nothing
void processCommands ( ifstream & commands ) {
   string currentOp , param1 , param2 ;
   Concordance < string , int > * activeConcordance = NULL ;
   ConcordanceItr < string , int > current ;
   int currentLineNo ;
   unsigned int pos ;
   string currentLine , currentWord ;
   ifstream theFile ;
   const ConcordanceEntry < string , int > notFound ( "***DOES_NOT_EXIST***" ) ;

   while ( commands >> currentOp ) {
      if ( currentOp == "PRINT" ) cout << "PRINT" << endl << endl << ( *activeConcordance ) << endl << endl ;


      else if ( currentOp == "PRINTENTRY" ) {
	 commands >> param1 ;
	 makeLower ( param1 ) ;
	 cout << "PRINTENTRY " << param1 << endl << endl ;
	 current = activeConcordance -> entry ( param1 ) ;
	 if ( current . retrieve ( ) != ConcordanceEntry < string , int > ( param1 ) ) cout << "No entry for " << param1 << endl << endl ; else cout << current . retrieve ( ) << endl << endl ;
      }


      else if ( currentOp == "PRINTRANGE" ) {
	 commands >> param1 ;
	 commands >> param2 ;
	 makeLower ( param1 ) ;
	 makeLower ( param2 ) ;
	 cout << "PRINTRANGE " << param1 << " " << param2 << endl << endl ;
	 for ( current = activeConcordance -> range ( param1 , param2 ) ; ! current . isPastEnd ( ) ; current . advance ( ) )
	    cout << current . retrieve ( ) << endl ;
	 cout << endl ;
      }



      else if ( currentOp == "LOAD" ) {
	 commands >> param1 ;
	 cout << "LOAD " << param1 << endl << endl ;

	 theFile . open ( param1 . c_str ( )  , ios::in ) ;
	 if ( ! theFile ) {
	    cout << "Unable to open file " << param1 << endl << endl ;
	 } else {
	    if ( activeConcordance ) delete activeConcordance ;
	    activeConcordance = new Concordance < string , int > ( notFound ) ;
	    currentLineNo = 0 ;
	    while ( getline ( theFile , currentLine ) ) {
	       makeLower ( currentLine ) ;
	       currentLineNo ++ ;
	       do {
		  pos = currentLine . find_first_of ( " .?!,;" ) ;
		  if ( pos >= string::npos ) {
		     if ( currentLine != "" )
			activeConcordance -> addLocation ( currentLine , currentLineNo ) ;
		  } else {
		     currentWord = currentLine . substr ( 0 , pos ) ;
		     currentLine = currentLine . substr ( pos + 1 , currentLine.size() - pos ) ;
		     if ( currentWord != "" )
			activeConcordance -> addLocation ( currentWord , currentLineNo ) ;
		  }
	       } while ( pos < string::npos ) ;
	    } ;

	    theFile . close ( ) ;

	    cout << param1 << " loaded" << endl << endl ;
	 }

      }
   } ;
}


// convert string to lower case
void makeLower ( string & s ) {
   for ( unsigned int i=0 ; i < s . size ( ) ; i++ )
      if ( s [ i ] >= 'A' && s [ i ] <= 'Z' ) s [ i ] += 32 ;
}
