#ifndef ConcordanceItr_H
#define ConcordanceItr_H

#include "Concordance.H"
#include "BSTIterator.H"
#include "ConcordanceEntry.H"

template < class Object , class Location >
class ConcordanceItr {
   public:
      // default constructor
      ConcordanceItr ( ) ;

      // copy constructor
      ConcordanceItr ( const ConcordanceItr < Object , Location > & copyThis ) ;

      // destructor
      ~ConcordanceItr ( ) ;

      // assignment operator
      const ConcordanceItr < Object , Location > & operator= ( const ConcordanceItr < Object , Location > & rhs ) ;

      // advance
      void advance ( void ) ;

      // are we done?
      bool isPastEnd ( void ) const ;

      // get value
      ConcordanceEntry < Object , Location > retrieve ( void ) const ;


   private:
      bool _isUpperBound ;
      Object _upperBound ;
      BinarySearchTreeItr < ConcordanceEntry < Object , Location > > _treeLoc ;

      friend class Concordance < Object , Location > ;
} ;

// just to make g++ happy
#include "ConcordanceItr.C"

#endif
