#include "ConcordanceItr.H"
#include "BSTIterator.H"
#include "ConcordanceEntry.H"

// default constructor
template < class Object , class Location >
ConcordanceItr < Object , Location > :: ConcordanceItr ( ) {
   _isUpperBound = false ;
}


// copy constructor
template < class Object , class Location >
ConcordanceItr < Object , Location > :: ConcordanceItr ( const ConcordanceItr < Object , Location > & rhs ) {
   ( * this ) = rhs ;
}


// assignment operator
template < class Object , class Location >
const ConcordanceItr < Object , Location >  & ConcordanceItr < Object , Location > :: operator= ( const ConcordanceItr < Object , Location > & rhs ) {
   _isUpperBound = rhs . _isUpperBound ;
   _upperBound = rhs . _upperBound ;
   _treeLoc = rhs . _treeLoc ;
   return rhs ;
}


// destructor
template < class Object , class Location >
ConcordanceItr < Object , Location > :: ~ConcordanceItr ( ) {
}


// advance
template < class Object , class Location >
void ConcordanceItr < Object , Location > :: advance ( void ) {
   _treeLoc . advance ( ) ;
}


// are we done?
template < class Object , class Location >
bool ConcordanceItr < Object , Location > :: isPastEnd ( void ) const {
   if ( _treeLoc . isPastEnd ( ) ) return true ;
   if ( _isUpperBound && ( _upperBound < ( _treeLoc . retrieve ( ) ) . _theObject ) ) return true ;
   return false ;
}


// get value
template < class Object , class Location >
ConcordanceEntry < Object , Location > ConcordanceItr < Object , Location > :: retrieve ( void ) const {
   return ( _treeLoc . retrieve ( ) ) ;
}
