#ifndef ConcordanceEntry_H
#define ConcordanceEntry_H

#include <iostream>
#include "LinkedList.H"
#include "Concordance.H"

template < class Object , class ListClass >
class Concordance ;

template < class Object , class ListClass >
class ConcordanceItr ;

template < class Object , class ListClass >
class ConcordanceEntry {
   public:

      // default constructor
      ConcordanceEntry ( ) ;

      // constructor with initial values
      ConcordanceEntry ( const Object what ) ;

      // copy constructor
      ConcordanceEntry ( const ConcordanceEntry < Object , ListClass > &copy ) ;

      // destructor
      ~ConcordanceEntry ( ) ;

      // add an item into the list
      void addLocation ( const ListClass & loc ) ;

      // assignment operator
      const ConcordanceEntry < Object , ListClass > &operator= ( const ConcordanceEntry < Object, ListClass >  & source ) ;

      // equality
      bool operator== ( const ConcordanceEntry < Object , ListClass > & rhs ) const ;

      // print to stream
      void print ( ostream &outStream ) const ;

      // comparison
      bool operator< ( const ConcordanceEntry < Object , ListClass > & rhs) const ;



   private:
      Object _theObject ;
      List < ListClass > _theList ;

      friend class Concordance < Object , ListClass > ;
      friend class ConcordanceItr < Object , ListClass > ;
} ;


// allow output to streams
template < class Object , class Location >
ostream &operator<< ( ostream & outStream , const ConcordanceEntry < Object , Location > &source ) ;

// to keep g++ happy, need the .C file
#include "ConcordanceEntry.C"


#endif
