#include <iostream>
#include "LinkedList.H"
#include "ConcordanceEntry.H"

// default constructor
template < class Object , class Location >
ConcordanceEntry < Object , Location > :: ConcordanceEntry ( ) { }





// constructor with initial value
template < class Object , class Location >
ConcordanceEntry < Object , Location > :: ConcordanceEntry ( Object what ) { 
   _theObject = what ;
}






// destructor
template < class Object , class Location >
ConcordanceEntry < Object , Location > :: ~ConcordanceEntry ( ) { }




// copy constructor
template < class Object , class Location >
ConcordanceEntry < Object , Location > :: ConcordanceEntry ( const ConcordanceEntry < Object , Location > & rhs ) {
   ( * this ) = rhs ;
}




// assignment operator
template < class Object , class Location >
const ConcordanceEntry < Object , Location > & ConcordanceEntry < Object , Location > :: operator= ( const ConcordanceEntry < Object, Location >  & rhs ) {
   _theList = rhs . _theList ;
   _theObject = rhs . _theObject ;
   return * this ;
}



// add an item into the list
template < class Object , class Location >
void ConcordanceEntry < Object , Location > :: addLocation ( const Location & loc ) {
   ListItr < Location > temp ;

   temp = _theList . find ( loc ) ;

   // only add into _theList if not already there
   if ( temp.isPastEnd ( ) )  _theList . insert ( loc , _theList . zeroth ( ) ) ;
}



// comparison
template < class Object , class Location >
bool ConcordanceEntry < Object , Location > :: operator< ( const ConcordanceEntry < Object , Location > & rhs) const {
   return ( _theObject < rhs . _theObject ) ;
}


// print to stream
template < class Object , class Location >
void ConcordanceEntry < Object , Location > :: print ( ostream & outStream ) const {
  List <Location> reverse;
  ListItr <Location> rItr = reverse.zeroth(), lItr = _theList.first();

  while (!lItr.isPastEnd()) {
    reverse.insert(lItr.retrieve(), rItr);
    lItr.advance();
  }

  outStream << _theObject << " - " ;

  rItr.advance();
  while (!rItr.isPastEnd()) {
    outStream << rItr.retrieve();
    rItr.advance();
    if (!rItr.isPastEnd())
      outStream << ", ";
  }
  outStream << endl;
}


// allow output to streams
template < class Object , class Location >
ostream &operator<< ( ostream & outStream , const ConcordanceEntry < Object , Location > &source ) {
   source . print ( outStream ) ;
   return outStream ;
}
