#ifndef Concordance_H
#define Concordance_H

#include "BinarySearchTree.H"
#include "ConcordanceEntry.H"
#include "ConcordanceItr.H"
#include <iostream>

template < class Object , class Location >
class Concordance {
   public:
      // constructor -- takes an item guaranteed not to be in the Concordance
      Concordance ( const ConcordanceEntry < Object , Location > & notFound ) ;

      // destructor
      ~Concordance ( ) ;

      // print the Concordance
      void print ( ostream & out ) const ;

      // copy constructor
      Concordance ( const Concordance < Object , Location > & copy ) ;

      // assignment operator
      const Concordance < Object , Location > &operator= ( const Concordance < Object, Location >  & source ) ;

      // add a location into the concordance
      void addLocation(const Object & obj, const Location & loc) ;

      // return an iterator to the first entry
      ConcordanceItr < Object , Location > first ( void ) const ;

      // return an iterator pointing to the specified object, else isPastEnd iterator
      ConcordanceItr < Object , Location > entry ( const Object & obj ) const ;

      // return an iterator between first and second
      ConcordanceItr < Object , Location > range ( const Object & first , const Object & second ) const ;


   private:
      BinarySearchTree < ConcordanceEntry < Object , Location > > _data ;
      ConcordanceEntry < Object , Location > ITEM_NOT_FOUND ;

} ;


// allow output to streams
template < class Object , class Location >
ostream &operator<< ( ostream & outStream , const Concordance < Object , Location > & source ) ;


// got to keep g++ happy
#include "Concordance.C"

#endif
