#include "BinarySearchTree.H"
#include "ConcordanceEntry.H"
#include "Concordance.H"
#include "ConcordanceItr.H"
#include <iostream>

// constructor
template < class Object , class Location >
Concordance < Object , Location > :: Concordance ( const ConcordanceEntry < Object , Location > & notFound ) {
   _data . newNotFound ( notFound ) ;
   ITEM_NOT_FOUND = notFound ;
}


// allow output to streams
template < class Object , class Location >
ostream &operator<< ( ostream & outStream , const Concordance < Object , Location > & source ) {
   source . print ( outStream ) ;
   return outStream ;
}



// print to stream
template < class Object , class Location >
void Concordance < Object , Location > :: print ( ostream & outStream ) const {
   for ( BinarySearchTreeItr < ConcordanceEntry < Object , Location > > current = _data . first ( ) ; ! current . isPastEnd () ; current . advance ( ) )
      outStream << current . retrieve ( ) << endl ;
}


// destructor
template < class Object , class Location >
Concordance < Object , Location > :: ~Concordance ( ) {
}


// copy constructor
template < class Object , class Location >
Concordance < Object , Location > :: Concordance ( const Concordance < Object , Location > & rhs ) {
   ( * this ) = rhs ;
}




// assignment operator
template < class Object , class Location >
const Concordance < Object , Location > & Concordance < Object , Location > :: operator= ( const Concordance < Object, Location >  & source ) {
   _data = source . _data ;
   ITEM_NOT_FOUND = source. ITEM_NOT_FOUND ;
   return * this ;
}



// add a location into the concordance
template < class Object , class Location >
void Concordance < Object , Location > :: addLocation ( const Object & obj , const Location & loc ) {
   bool done = false ;
   ConcordanceEntry < Object , Location > addThis ( obj ) ;
   ConcordanceEntry < Object , Location > current , temp2 ;

   for ( BinarySearchTreeItr < ConcordanceEntry < Object , Location > > temp = _data . first ( ) ; ! temp . isPastEnd ( ) ; temp . advance ( ) ) {
      current = temp . retrieve ( ) ;
      if ( current . _theObject == obj ) {
	 done = true ;

         // check to make sure location not already in there
	 if ( ( current . _theList . find ( loc ) ) . isPastEnd ( ) ) {
	    addThis = current ;
	    _data . remove ( addThis ) ;

	    addThis . _theList . insert ( loc , addThis . _theList . zeroth ( ) ) ;
	    _data . insert ( addThis ) ;
	 }
      }
   }

   if ( ! done ) {
      addThis . _theList . insert ( loc , addThis . _theList . zeroth ( ) ) ;
      _data . insert ( addThis ) ;
   }
}



// get an iterator to first concordance entry
template < class Object , class Location >
ConcordanceItr < Object , Location > Concordance < Object , Location > :: first ( void ) const {
   ConcordanceItr < Object , Location > temp ;

   temp . _isUpperBound = false ;
   temp . _treeLoc = _data . first ( ) ;

   return temp ;
}


// get an iterator between first and last
template < class Object , class Location >
ConcordanceItr < Object , Location > Concordance < Object , Location > :: range ( const Object & first , const Object & last ) const {
   ConcordanceItr < Object , Location > temp ;

   temp = entry ( first ) ;
   temp . _isUpperBound = true ;
   temp . _upperBound = last ;

   return temp ;
}


// get an iterator to concordance entry for obj
template < class Object , class Location >
ConcordanceItr < Object , Location > Concordance < Object , Location > :: entry ( const Object & obj ) const {
   ConcordanceItr < Object , Location > temp ;
   bool match = false ;

   temp = first ( ) ;
   while ( ! ( temp . isPastEnd ( ) ) && ( ! match ) ) {
      if ( ! ( ( temp . retrieve ( ) ) . _theObject < obj ) ) match = true ;
      else temp . advance ( ) ;
   }

   return temp ;
}


// equality
template < class Object , class Location >
bool ConcordanceEntry < Object , Location > :: operator== ( const ConcordanceEntry < Object , Location > & rhs ) const {
   return ( ! ( ( ( * this ) < rhs ) || ( rhs < ( * this ) ) ) ) ;
}
