#ifndef BSTIterator_H
#define BSTIterator_H

#include "LinkedList.H"
#include "BinarySearchTree.H"

template < class Comparable >
class BinarySearchTree ;

template < class Comparable >
class BinarySearchTreeItr {
   public:

      // default constructor
      BinarySearchTreeItr ( ) ;

      // copy constructor
      BinarySearchTreeItr ( const BinarySearchTreeItr < Comparable > & copyThis ) ;

      // destructor
      ~BinarySearchTreeItr ( ) ;

      // assignment operator
      const BinarySearchTreeItr < Comparable > & operator= ( const BinarySearchTreeItr < Comparable > & source ) ;

      // advance
      void advance ( void ) ;

      // are we done?
      bool isPastEnd ( void ) const ;

      // get value
      const Comparable & retrieve ( void ) const { return _current . retrieve ( ) ; }


   private:
      List < Comparable> _theList ;
      ListItr < Comparable > _current ;

      friend class BinarySearchTree < Comparable > ;
} ;

// got to keep g++ happy
#include "BSTIterator.C"

#endif
