/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimulationController {
    public static final int INDEFINITE = 0;
    public static final int FIXED_STEPS = 1;
    public static final int PROMPT_STEPS = 2;
    private static final int MIN_DELAY_MSECS = 10;
    private static final int MAX_DELAY_MSECS = 1000;
    private static final int INITIAL_DELAY = 505;
    private Simulation simulation;
    private Timer timer;
    private JButton stepButton;
    private JButton runButton;
    private JButton stopButton;
    private JComponent controlPanel;
    private MBSDisplay display;
    private EnvironmentController envControl;
    private MBSGUIFrame parentFrame;
    private int runOption;
    private int numStepsToRun;
    private int numStepsSoFar;

    public SimulationController(MBSGUIFrame mBSGUIFrame, MBSDisplay mBSDisplay) {
        this.display = mBSDisplay;
        this.parentFrame = mBSGUIFrame;
        this.makeControls();
        this.timer = new Timer(505, new 1());
    }

    public void step() {
        this.envControl.setFishToolbarVisible(false);
        this.simulation.step();
        if (++this.numStepsSoFar == this.numStepsToRun) {
            this.stop();
        }
    }

    public void run() {
        if (this.runOption == 2 && !this.promptUserForStepCount()) {
            return;
        }
        this.display.setToolTipsEnabled(false);
        this.parentFrame.setRunMenuItemsEnabled(false);
        this.stopButton.setEnabled(true);
        this.stepButton.setEnabled(false);
        this.runButton.setEnabled(false);
        this.numStepsSoFar = 0;
        this.timer.start();
    }

    public void stop() {
        this.display.setToolTipsEnabled(true);
        this.parentFrame.setRunMenuItemsEnabled(true);
        this.timer.stop();
        this.stopButton.setEnabled(false);
        this.runButton.setEnabled(true);
        this.stepButton.setEnabled(true);
    }

    public int setRunOption(int n) {
        switch (n) {
            case 0: {
                this.runButton.setText("Run");
                this.numStepsToRun = 0;
                break;
            }
            case 1: {
                if (!this.promptUserForStepCount()) {
                    return this.runOption;
                }
                this.runButton.setText("Run for " + this.numStepsToRun + " step" + (this.numStepsToRun == 1 ? "" : "s"));
                break;
            }
            case 2: {
                this.runButton.setText("Run...");
            }
        }
        this.runOption = n;
        return this.runOption;
    }

    private boolean promptUserForStepCount() {
        int n = this.numStepsToRun > 0 ? this.numStepsToRun : 10;
        String string = (String)JOptionPane.showInputDialog(this.parentFrame, "Enter number of steps:", "Input", 3, null, null, String.valueOf(n));
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string.trim());
                if (n2 <= 0) {
                    throw new NumberFormatException();
                }
                this.numStepsToRun = n2;
                return true;
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        return false;
    }

    private void makeControls() {
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 0));
        this.controlPanel.setBorder(BorderFactory.createTitledBorder("Simulation"));
        this.controlPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.stepButton = new JButton("Step");
        this.controlPanel.add(this.stepButton);
        this.runButton = new JButton("Run");
        this.controlPanel.add(this.runButton);
        this.stopButton = new JButton("Stop");
        this.controlPanel.add(this.stopButton);
        this.runButton.setEnabled(false);
        this.stepButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.controlPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.controlPanel.add(new JLabel("Slow"));
        JSlider jSlider = new JSlider(10, 1000, 505);
        jSlider.setInverted(true);
        jSlider.setPreferredSize(new Dimension(100, jSlider.getPreferredSize().height));
        jSlider.setMaximumSize(jSlider.getPreferredSize());
        this.controlPanel.add(jSlider);
        this.controlPanel.add(new JLabel("Fast"));
        this.controlPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.stepButton.addActionListener(new 2());
        this.runButton.addActionListener(new 3());
        this.stopButton.addActionListener(new 4());
        jSlider.addChangeListener(new 5());
    }

    public JComponent controlPanel() {
        return this.controlPanel;
    }

    public void setEnv(Environment environment, EnvironmentController environmentController) {
        this.stop();
        this.simulation = new Simulation(environment, (EnvDisplay)this.display);
        this.envControl = environmentController;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SimulationController.this.step();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SimulationController.this.step();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SimulationController.this.run();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SimulationController.this.stop();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            SimulationController.this.timer.setDelay(((JSlider)changeEvent.getSource()).getValue());
        }

        /* synthetic */ 5() {
        }
    }
}

