/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PseudoInfiniteViewport
extends JViewport {
    private static final int ORIGIN_TIP_DELAY = 1000;
    private JScrollPane scrollParent;
    private JPanel glassPane;
    private JToolTip originTip;
    private Timer originTipTimer;
    private Point panPoint = new Point(0, 0);

    public PseudoInfiniteViewport(JScrollPane jScrollPane) {
        this.scrollParent = jScrollPane;
        this.setBackground(Color.lightGray);
    }

    public void setViewPosition(Point point) {
        boolean bl = this.scrollParent.getVerticalScrollBar().getValueIsAdjusting() || this.scrollParent.getHorizontalScrollBar().getValueIsAdjusting();
        boolean bl2 = true;
        if (this.viewIsUnbounded()) {
            int n = point.x - this.panPoint.x;
            int n2 = point.y - this.panPoint.y;
            if (n != 0 && n2 == 0) {
                this.getPannableView().panBy(n, n2);
            } else if (n2 != 0 && n == 0) {
                this.getPannableView().panBy(n, n2);
            } else {
                bl2 = false;
            }
            this.panPoint = point;
            if (!this.panPoint.equals(this.getPanCenterPoint()) && !bl) {
                this.panPoint = this.getPanCenterPoint();
                this.fireStateChanged();
            }
        } else {
            bl2 = this.getViewPosition().equals(point) ^ true;
            super.setViewPosition(point);
        }
        if (bl2 || bl) {
            this.showOriginTip();
        }
    }

    public Point getViewPosition() {
        return this.viewIsUnbounded() ? this.getPanCenterPoint() : super.getViewPosition();
    }

    public Dimension getViewSize() {
        return this.viewIsUnbounded() ? this.getView().getPreferredSize() : super.getViewSize();
    }

    public void showOriginTip() {
        String string;
        if (this.getRootPane() == null) {
            return;
        }
        if (this.glassPane == null) {
            this.glassPane = new JPanel();
            this.getRootPane().setGlassPane(this.glassPane);
            this.glassPane.setOpaque(false);
            this.glassPane.setLayout(null);
            this.originTip = new JToolTip();
            this.glassPane.add(this.originTip);
            this.originTipTimer = new Timer(1000, new 1());
            this.originTipTimer.setRepeats(false);
        }
        if ((string = this.getPannableView().getPannableTipText()) == null) {
            return;
        }
        this.originTip.setTipText(string);
        this.originTip.setLocation(SwingUtilities.convertPoint(this, this.getLocation(), this.glassPane));
        this.originTip.setSize(this.originTip.getPreferredSize());
        this.glassPane.setVisible(true);
        this.originTipTimer.restart();
    }

    private Pannable getPannableView() {
        return (Pannable)((Object)this.getView());
    }

    private boolean viewIsUnbounded() {
        Pannable pannable = this.getPannableView();
        return pannable != null && pannable.isPannableUnbounded();
    }

    private Point getPanCenterPoint() {
        Dimension dimension = this.getViewSize();
        return new Point(dimension.width / 2, dimension.height / 2);
    }

    public static interface Pannable {
        public void panBy(int var1, int var2);

        public boolean isPannableUnbounded();

        public String getPannableTipText();
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            PseudoInfiniteViewport.this.glassPane.setVisible(false);
        }

        /* synthetic */ 1() {
        }
    }
}

