/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class MBSGUIFrame
extends JFrame {
    private static final String VERSION_ID = "1.0)";
    private static final String VERSION_DATE = "1 August 2002";
    private EnvironmentController envControl;
    private SimulationController simControl;
    private MBSDisplay display;
    private ArrayList menuItemsThatNeedAnEnvironment;
    private ArrayList menuItemsDisabledDuringRun;
    static /* synthetic */ Class class$MBSGUIFrame$GUIExceptionHandler;
    static /* synthetic */ Class class$Fish;

    public MBSGUIFrame() {
        System.setProperty("sun.awt.exception.handler", (class$MBSGUIFrame$GUIExceptionHandler != null ? class$MBSGUIFrame$GUIExceptionHandler : (class$MBSGUIFrame$GUIExceptionHandler = MBSGUIFrame.class$("MBSGUIFrame$GUIExceptionHandler"))).getName());
        this.setTitle("Marine Biology Simulation");
        ((Component)this).setLocation(25, 15);
        this.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        this.setContentPane(jPanel);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        jPanel.setLayout(new BorderLayout());
        this.display = new MBSDisplay();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewport(new PseudoInfiniteViewport(jScrollPane));
        jScrollPane.setViewportView(this.display);
        jPanel.add((Component)jScrollPane, "Center");
        this.simControl = new SimulationController(this, this.display);
        jPanel.add((Component)this.simControl.controlPanel(), "South");
        this.envControl = new EnvironmentController(this, this.display, this.simControl);
        jPanel.add((Component)this.envControl.controlPanel(), "East");
        this.makeMenus();
        this.pack();
    }

    private void makeMenus() {
        int n = this.getToolkit().getMenuShortcutKeyMask();
        JMenuBar jMenuBar = new JMenuBar();
        this.menuItemsThatNeedAnEnvironment = new ArrayList();
        this.menuItemsDisabledDuringRun = new ArrayList();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open environment file...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new 1());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
        jMenuItem = new JMenuItem("Create new environment...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new 2());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, n));
        jMenuItem = new JMenuItem("Edit environment...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new 3());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, n));
        this.menuItemsThatNeedAnEnvironment.add(jMenuItem);
        jMenuItem = new JMenuItem("Save environment as...");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, n));
        jMenuItem.addActionListener(new 4());
        this.menuItemsThatNeedAnEnvironment.add(jMenuItem);
        jMenuItem = new JMenuItem("Quit");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
        jMenuItem.addActionListener(new 5());
        jMenu = new JMenu("Seed");
        jMenuBar.add(jMenu);
        JMenu jMenu2 = jMenu;
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenuItem = new JRadioButtonMenuItem("Don't reset seed", true);
        jMenu.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.addActionListener(new 6());
        jMenuItem = new JRadioButtonMenuItem("Use fixed seed...");
        jMenu.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.addActionListener(new 7(jMenu2, this));
        jMenuItem = new JRadioButtonMenuItem("Prompt for seed");
        jMenu.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.addActionListener(new 8());
        jMenu = new JMenu("Run");
        jMenuBar.add(jMenu);
        JMenu jMenu3 = jMenu;
        buttonGroup = new ButtonGroup();
        jMenuItem = new JRadioButtonMenuItem("Run Indefinitely", true);
        jMenu.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.addActionListener(new 9());
        this.menuItemsDisabledDuringRun.add(jMenuItem);
        jMenuItem = new JRadioButtonMenuItem("Use fixed number of steps...");
        jMenu.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.addActionListener(new 10(jMenu3, this));
        this.menuItemsDisabledDuringRun.add(jMenuItem);
        jMenuItem = new JRadioButtonMenuItem("Prompt for number of steps");
        jMenu.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.addActionListener(new 11());
        this.menuItemsDisabledDuringRun.add(jMenuItem);
        jMenu = new JMenu("View");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Zoom in");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new 12());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, n));
        this.menuItemsThatNeedAnEnvironment.add(jMenuItem);
        jMenuItem = new JMenuItem("Zoom out");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new 13());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(40, n));
        this.menuItemsThatNeedAnEnvironment.add(jMenuItem);
        jMenuItem = new JMenuItem("Bring (0, 0) to upper left");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new 14());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, n));
        this.menuItemsThatNeedAnEnvironment.add(jMenuItem);
        try {
            Method method = (class$Fish != null ? class$Fish : (class$Fish = MBSGUIFrame.class$("Fish"))).getMethod("enableBreedDie", Boolean.TYPE);
            method.invoke((Object)(class$Fish != null ? class$Fish : (class$Fish = MBSGUIFrame.class$("Fish"))), new Boolean(true));
            jMenu = new JMenu("Special");
            jMenuBar.add(jMenu);
            JMenu jMenu4 = jMenu;
            buttonGroup = new ButtonGroup();
            jMenuItem = new JRadioButtonMenuItem("Enable breed and die", true);
            jMenu.add(jMenuItem);
            buttonGroup.add(jMenuItem);
            jMenuItem.addActionListener(new 15(method));
            jMenuItem = new JRadioButtonMenuItem("Disable breed and die");
            jMenu.add(jMenuItem);
            buttonGroup.add(jMenuItem);
            jMenuItem.addActionListener(new 16(method));
        }
        catch (Exception exception) {}
        jMenu = new JMenu("Help");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("About MBSGUI...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new 17());
        jMenuItem = new JMenuItem("Help...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new 18());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(156, n));
        this.setEnvMenuItemsEnabled(false);
        this.setRunMenuItemsEnabled(true);
        this.setJMenuBar(jMenuBar);
    }

    public void setEnvMenuItemsEnabled(boolean bl) {
        Iterator iterator = ((AbstractList)this.menuItemsThatNeedAnEnvironment).iterator();
        while (iterator.hasNext()) {
            ((JMenuItem)iterator.next()).setEnabled(bl);
        }
    }

    public void setRunMenuItemsEnabled(boolean bl) {
        Iterator iterator = ((AbstractList)this.menuItemsDisabledDuringRun).iterator();
        while (iterator.hasNext()) {
            ((JMenuItem)iterator.next()).setEnabled(bl);
        }
    }

    private void showAboutPanel() {
        String string = "<html><h2>Marine Biology Simulation Program<br>with Graphical User Interface (MBSGUI)</h2>A tool for running and viewing the AP&reg; Computer Science<p>Marine Biology Simulation case study program.<p><p><font size=-1>Version: 1 August 2002</font><p><font size=-1>Copyright&copy; 2002 College Entrance Examination Board (www.collegeboard.com).</font></font></html>";
        JOptionPane.showMessageDialog(this, new JLabel(string), "About MBSGUI", 1, new FishToolbar.FishIcon(class$Fish != null ? class$Fish : (class$Fish = MBSGUIFrame.class$("Fish")), Color.magenta, 48, 48));
    }

    private void showHelp() {
        JDialog jDialog = new JDialog((Frame)this, "MBSGUI Help");
        JEditorPane jEditorPane = new JEditorPane();
        try {
            jEditorPane.setPage(this.getClass().getResource("MBSHelp.html"));
        }
        catch (Exception exception) {
            jEditorPane.setText("Couldn't load help file.");
        }
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(new 19(jEditorPane));
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setPreferredSize(new Dimension(650, 500));
        jDialog.getContentPane().add(jScrollPane);
        ((Component)jDialog).setLocation(this.getX() + this.getWidth() - 200, this.getY() + 50);
        jDialog.pack();
        ((Component)jDialog).setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.envControl.openFile();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.envControl.createNewEnv();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.envControl.editEnv();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.envControl.saveFile();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.envControl.setSeedOption(0);
        }

        /* synthetic */ 6() {
        }
    }

    private static final class 7
    implements ActionListener {
        private final /* synthetic */ JMenu val$seedMenu;
        private final /* synthetic */ MBSGUIFrame this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.this$0.envControl.setSeedOption(1);
            this.val$seedMenu.getItem(n).setSelected(true);
        }

        /* synthetic */ 7(JMenu jMenu, MBSGUIFrame mBSGUIFrame) {
            this.val$seedMenu = jMenu;
            this.this$0 = mBSGUIFrame;
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.envControl.setSeedOption(2);
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.simControl.setRunOption(0);
        }

        /* synthetic */ 9() {
        }
    }

    private static final class 10
    implements ActionListener {
        private final /* synthetic */ JMenu val$runMenu;
        private final /* synthetic */ MBSGUIFrame this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.this$0.simControl.setRunOption(1);
            this.val$runMenu.getItem(n).setSelected(true);
        }

        /* synthetic */ 10(JMenu jMenu, MBSGUIFrame mBSGUIFrame) {
            this.val$runMenu = jMenu;
            this.this$0 = mBSGUIFrame;
        }
    }

    private final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.simControl.setRunOption(2);
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.display.zoomIn();
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.display.zoomOut();
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.display.recenterOnOrigin();
        }

        /* synthetic */ 14() {
        }
    }

    private static final class 15
    implements ActionListener {
        private final /* synthetic */ Method val$m;

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.val$m.invoke((Object)(class$Fish != null ? class$Fish : (class$Fish = MBSGUIFrame.class$("Fish"))), new Boolean(true));
            }
            catch (Exception exception) {}
        }

        /* synthetic */ 15(Method method) {
            this.val$m = method;
        }
    }

    private static final class 16
    implements ActionListener {
        private final /* synthetic */ Method val$m;

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.val$m.invoke((Object)(class$Fish != null ? class$Fish : (class$Fish = MBSGUIFrame.class$("Fish"))), new Boolean(false));
            }
            catch (Exception exception) {}
        }

        /* synthetic */ 16(Method method) {
            this.val$m = method;
        }
    }

    private final class 17
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.showAboutPanel();
        }

        /* synthetic */ 17() {
        }
    }

    private final class 18
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MBSGUIFrame.this.showHelp();
        }

        /* synthetic */ 18() {
        }
    }

    private static final class 19
    implements HyperlinkListener {
        private final /* synthetic */ JEditorPane val$helpText;

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            block2: {
                if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block2;
                try {
                    this.val$helpText.setPage(hyperlinkEvent.getURL());
                }
                catch (Exception exception) {}
            }
        }

        /* synthetic */ 19(JEditorPane jEditorPane) {
            this.val$helpText = jEditorPane;
        }
    }

    public static class GUIExceptionHandler {
        public void handle(Throwable throwable) {
            throwable.printStackTrace();
            JOptionPane.showMessageDialog(null, "An error occurred. The simulation must exit.\nReason: " + throwable, "Error", 0);
            System.exit(0);
        }
    }
}

