/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;

public class MBSDisplay
extends JPanel
implements EnvDisplay,
Scrollable,
PseudoInfiniteViewport.Pannable {
    private static final int MIN_CELL_SIZE = 8;
    private static final int DEFAULT_CELL_SIZE = 16;
    private static final Color OCEAN_BLUE = new Color(75, 75, 255);
    private Environment theEnv;
    private int numRows;
    private int numCols;
    private int originRow;
    private int originCol;
    private int cellSize;
    private boolean toolTipsEnabled;

    public MBSDisplay(Environment environment) {
        this.setToolTipsEnabled(true);
        this.addComponentListener(new 1());
        if (environment != null) {
            this.setEnv(environment);
        }
    }

    public MBSDisplay() {
        this((Environment)null);
    }

    public void showEnv() {
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        if (this.theEnv == null) {
            return;
        }
        Insets insets = this.getInsets();
        graphics2D.setColor(OCEAN_BLUE);
        graphics2D.fillRect(insets.left, insets.top, this.numCols * this.cellSize, this.numRows * this.cellSize);
        this.drawGridlines(graphics2D);
        Locatable[] locatableArray = this.theEnv.allObjects();
        int n = 0;
        while (n < locatableArray.length) {
            this.drawLocatable(graphics2D, locatableArray[n]);
            ++n;
        }
    }

    private void drawLocatable(Graphics2D graphics2D, Locatable locatable) {
        Rectangle rectangle = new Rectangle(this.colToXCoord(locatable.location().col()) + 1, this.rowToYCoord(locatable.location().row()) + 1, this.cellSize - 1, this.cellSize - 1);
        if (rectangle.intersects(graphics2D.getClip().getBounds())) {
            AffineTransform affineTransform = graphics2D.getTransform();
            LocatableDisplay locatableDisplay = DisplayMap.findDisplayFor(locatable);
            locatableDisplay.draw(locatable, this, graphics2D, rectangle);
            graphics2D.setTransform(affineTransform);
        }
    }

    private void drawGridlines(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClip().getBounds();
        int n = this.getInsets().top;
        int n2 = this.getInsets().left;
        int n3 = Math.max(0, (rectangle.y - n) / this.cellSize) * this.cellSize + n;
        int n4 = Math.max(0, (rectangle.x - n2) / this.cellSize) * this.cellSize + n2;
        int n5 = Math.min(this.numRows, (rectangle.y + rectangle.height - n + this.cellSize - 1) / this.cellSize) * this.cellSize + n;
        int n6 = Math.min(this.numCols, (rectangle.x + rectangle.width - n2 + this.cellSize - 1) / this.cellSize) * this.cellSize + n2;
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke());
        int n7 = n3;
        while (n7 <= n5) {
            graphics2D.drawLine(n4, n7, n6, n7);
            n7 += this.cellSize;
        }
        int n8 = n4;
        while (n8 <= n6) {
            graphics2D.drawLine(n8, n3, n8, n5);
            n8 += this.cellSize;
        }
    }

    public void setToolTipsEnabled(boolean bl) {
        if (bl) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
        this.toolTipsEnabled = bl;
    }

    public void setEnv(Environment environment) {
        JViewport jViewport = this.getEnclosingViewport();
        if (jViewport != null) {
            jViewport.setViewPosition(new Point(0, 0));
        }
        this.theEnv = environment;
        this.originCol = 0;
        this.originRow = 0;
        if (this.theEnv.numRows() == -1 && this.theEnv.numCols() == -1) {
            this.numCols = 2000;
            this.numRows = 2000;
        } else {
            this.numRows = this.theEnv.numRows();
            this.numCols = this.theEnv.numCols();
        }
        this.recalculateCellSize(16);
    }

    private int extraWidth() {
        return this.getInsets().left + this.getInsets().right + 1;
    }

    private int extraHeight() {
        return this.getInsets().top + this.getInsets().left + 1;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.numCols * this.cellSize + this.extraWidth(), this.numRows * this.cellSize + this.extraHeight());
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.numCols * 8 + this.extraWidth(), this.numRows * 8 + this.extraHeight());
    }

    public void zoomIn() {
        this.cellSize *= 2;
        this.revalidate();
    }

    public void zoomOut() {
        this.cellSize = Math.max(this.cellSize / 2, 8);
        this.revalidate();
    }

    public void recenterOnOrigin() {
        this.originRow = 0;
        this.originCol = 0;
        this.repaint();
        JViewport jViewport = this.getEnclosingViewport();
        if (jViewport != null) {
            if (!this.isPannableUnbounded() || !(jViewport instanceof PseudoInfiniteViewport)) {
                jViewport.setViewPosition(new Point(0, 0));
            } else {
                ((PseudoInfiniteViewport)jViewport).showOriginTip();
            }
        }
    }

    public Location locationForPoint(Point point) {
        Location location = new Location(this.yCoordToRow(point.y), this.xCoordToCol(point.x));
        return this.theEnv != null && this.theEnv.isValid(location) ? location : null;
    }

    private int xCoordToCol(int n) {
        return (n - this.getInsets().left) / this.cellSize + this.originCol;
    }

    private int yCoordToRow(int n) {
        return (n - this.getInsets().top) / this.cellSize + this.originRow;
    }

    private int colToXCoord(int n) {
        return (n - this.originCol) * this.cellSize + this.getInsets().left;
    }

    private int rowToYCoord(int n) {
        return (n - this.originRow) * this.cellSize + this.getInsets().top;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Location location = this.locationForPoint(mouseEvent.getPoint());
        if (!this.toolTipsEnabled || location == null) {
            return null;
        }
        Fish fish = (Fish)this.theEnv.objectAt(location);
        if (fish != null) {
            return String.valueOf(fish.getClass().getName()) + " id #" + fish.id() + " at " + location + " facing " + fish.direction();
        }
        return String.valueOf(String.valueOf(location)) + " is empty";
    }

    private void recalculateCellSize(int n) {
        if (this.numRows == 0 || this.numCols == 0) {
            this.cellSize = 0;
        } else {
            JViewport jViewport = this.getEnclosingViewport();
            Dimension dimension = jViewport != null ? jViewport.getSize() : this.getSize();
            this.cellSize = Math.min((dimension.height - this.extraHeight()) / this.numRows, (dimension.width - this.extraWidth()) / this.numCols);
            this.cellSize = Math.max(this.cellSize, n);
        }
        this.revalidate();
    }

    private JViewport getEnclosingViewport() {
        Container container = this.getParent();
        return container instanceof JViewport ? (JViewport)container : null;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.cellSize;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return (int)((double)rectangle.height * 0.9);
        }
        return (int)((double)rectangle.width * 0.9);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(420, 420);
    }

    public void panBy(int n, int n2) {
        this.originCol += n / this.cellSize;
        this.originRow += n2 / this.cellSize;
        this.repaint();
    }

    public boolean isPannableUnbounded() {
        return this.theEnv != null && this.theEnv.numRows() == -1;
    }

    public String getPannableTipText() {
        Location location;
        Point point = new Point(0, 0);
        JViewport jViewport = this.getEnclosingViewport();
        if (!this.isPannableUnbounded() && jViewport != null) {
            point = jViewport.getViewPosition();
        }
        return (location = this.locationForPoint(point)) != null ? location.toString() : null;
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            if (MBSDisplay.this.getEnclosingViewport() == null) {
                MBSDisplay.this.recalculateCellSize(8);
            }
        }

        /* synthetic */ 1() {
        }
    }
}

