/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;

public class FishToolbar
extends JToolBar {
    private JComboBox colorComboBox;
    private JComboBox fishComboBox;
    static /* synthetic */ Class class$Fish;

    public FishToolbar() {
        super(1);
        this.setFloatable(false);
        this.makeTools();
    }

    public Class currentFishClass() {
        return ((FishChoice)this.fishComboBox.getSelectedItem()).getFishClass();
    }

    public Color currentColor() {
        ColorChoice colorChoice = (ColorChoice)this.colorComboBox.getSelectedItem();
        if (colorChoice == ColorChoice.random) {
            Random random = RandNumGenerator.getInstance();
            return new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
        }
        return colorChoice.getColor();
    }

    private void makeTools() {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Configure new fish"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.add(new JLabel(" Type: "));
        this.fishComboBox = new JComboBox();
        FishChoice.addChoicesFromFactory(this.fishComboBox);
        this.fishComboBox.setRenderer(new ChoiceWithIconRenderer(this.fishComboBox));
        this.fishComboBox.setAlignmentX(0.0f);
        this.fishComboBox.addActionListener(new 1());
        this.add(this.fishComboBox);
        this.addSeparator();
        this.add(new JLabel(" Color: "));
        this.colorComboBox = new JComboBox<ColorChoice>(ColorChoice.standardChoices);
        this.colorComboBox.setSelectedItem(ColorChoice.random);
        this.colorComboBox.setRenderer(new ChoiceWithIconRenderer(this.colorComboBox));
        this.colorComboBox.setAlignmentX(0.0f);
        this.colorComboBox.addActionListener(new 2());
        this.add(this.colorComboBox);
        this.add(Box.createGlue());
    }

    private void colorChosen() {
        ColorChoice colorChoice = (ColorChoice)this.colorComboBox.getSelectedItem();
        if (colorChoice == ColorChoice.custom) {
            this.colorComboBox.hidePopup();
            Frame frame = JOptionPane.getFrameForComponent(this);
            Color color = JColorChooser.showDialog(frame, "Choose Fish Color", colorChoice.getColor());
            if (color != null) {
                colorChoice.setColor(color);
            }
        }
    }

    private void fishChosen() {
        FishChoice fishChoice = (FishChoice)this.fishComboBox.getSelectedItem();
        this.colorComboBox.setEnabled(MBSFactory.hasFourArgCtor((Class)fishChoice.getFishClass()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FishToolbar.this.fishChosen();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FishToolbar.this.colorChosen();
        }

        /* synthetic */ 2() {
        }
    }

    private static interface ChoiceWithIcon {
        public Icon getIcon();
    }

    private static class ColorChoice
    implements ChoiceWithIcon {
        public static final ColorChoice random = new ColorChoice("Random", ColorIcon.RANDOM_COLOR);
        public static final ColorChoice custom = new ColorChoice("Other ...", Color.white);
        private Color color;
        private String name;
        private ColorIcon icon;
        public static final ColorChoice[] standardChoices = new ColorChoice[]{new ColorChoice("Red", Color.red), new ColorChoice("Orange", new Color(255, 128, 0)), new ColorChoice("Yellow", Color.yellow), new ColorChoice("Green", Color.green), new ColorChoice("Blue", new Color(0, 128, 255)), new ColorChoice("Purple", new Color(128, 0, 128)), random, custom};

        public ColorChoice(String string, Color color) {
            this.color = color;
            this.name = string;
            this.icon = new ColorIcon(this.color, 16, 16);
        }

        public void setColor(Color color) {
            this.color = color;
            this.icon.setColor(color);
        }

        public Color getColor() {
            return this.color;
        }

        public String toString() {
            return this.name;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }

    private static class FishChoice
    implements ChoiceWithIcon {
        private Class cls;
        private FishIcon icon;

        public FishChoice(Class clazz) {
            this.cls = clazz;
            this.icon = new FishIcon(this.cls, Color.gray, 16, 16);
        }

        public Class getFishClass() {
            return this.cls;
        }

        public String toString() {
            return this.cls.getName();
        }

        public Icon getIcon() {
            return this.icon;
        }

        public static void addChoicesFromFactory(JComboBox jComboBox) {
            Iterator iterator = MBSFactory.envObjectClasses().iterator();
            while (iterator.hasNext()) {
                FishChoice fishChoice = new FishChoice((Class)iterator.next());
                jComboBox.addItem(fishChoice);
                if (fishChoice.getFishClass() != (class$Fish != null ? class$Fish : FishToolbar.class$("Fish"))) continue;
                jComboBox.setSelectedItem(fishChoice);
            }
        }
    }

    private static class ChoiceWithIconRenderer
    extends JLabel
    implements ListCellRenderer {
        private JComboBox cb;

        public ChoiceWithIconRenderer(JComboBox jComboBox) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.cb = jComboBox;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (!this.cb.isEnabled()) {
                this.setText("No choice");
                this.setIcon(null);
            } else {
                this.setText(object.toString());
                this.setIcon(((ChoiceWithIcon)object).getIcon());
            }
            return this;
        }
    }

    private static class ColorIcon
    implements Icon {
        public static final Color RANDOM_COLOR = new Color(0, 0, 0);
        private static final int MARGIN = 2;
        private Color color;
        private int width;
        private int height;

        public ColorIcon(Color color, int n, int n2) {
            this.color = color;
            this.width = n;
            this.height = n2;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = new Rectangle(n + 2, n2 + 2, this.width - 4, this.height - 4);
            if (this.color != RANDOM_COLOR) {
                graphics2D.setColor(this.color);
                graphics2D.fill(rectangle);
            } else {
                int n3 = 0;
                while (n3 < rectangle.width) {
                    graphics2D.setColor(Color.getHSBColor((float)n3 / (float)rectangle.width, 0.95f, 1.0f));
                    graphics2D.drawLine(rectangle.x + n3, rectangle.y, rectangle.x + n3, rectangle.y + rectangle.height);
                    ++n3;
                }
            }
            graphics2D.setColor(Color.black);
            graphics2D.draw(rectangle);
        }
    }

    static class FishIcon
    implements Icon {
        private Fish fish;
        private Class cls;
        private Color color;
        private int width;
        private int height;

        public FishIcon(Class clazz, Color color, int n, int n2) {
            this.cls = clazz;
            this.color = color;
            this.width = n;
            this.height = n2;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.fish == null) {
                this.fish = MBSFactory.hasFourArgCtor((Class)this.cls) ? (Fish)MBSFactory.constructEnvObject((Class)this.cls, (Environment)new BoundedEnv(1, 1), (Location)new Location(0, 0), (Direction)Direction.EAST, (Color)this.color) : (Fish)MBSFactory.constructEnvObject((Class)this.cls, (Environment)new BoundedEnv(1, 1), (Location)new Location(0, 0), (Direction)Direction.EAST);
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            LocatableDisplay locatableDisplay = DisplayMap.findDisplayFor((Locatable)this.fish);
            locatableDisplay.draw((Locatable)this.fish, component, graphics2D, new Rectangle(n, n2, this.getIconWidth(), this.getIconHeight()));
            graphics2D.setTransform(affineTransform);
        }
    }
}

