/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Ellipse2D;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class FishImageDisplay
extends AbstractFishDisplay {
    private ImageIcon icon;
    private Image originalImage;
    private Direction originalDirection;
    private HashMap tintedVersions = new HashMap();

    public FishImageDisplay(String string, Direction direction) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            this.icon = new ImageIcon(uRL);
        } else {
            String string2 = String.valueOf(System.getProperty("user.dir")) + File.separator + string;
            this.icon = new ImageIcon(string2);
        }
        this.originalDirection = direction;
        this.originalImage = this.icon.getImage();
    }

    public void draw(Fish fish, Component component, Graphics2D graphics2D) {
        if (this.icon.getImageLoadStatus() != 8) {
            graphics2D.setPaint(fish.color());
            graphics2D.fill(new Ellipse2D.Double(-0.4, -0.4, 0.8, 0.8));
            return;
        }
        if (!this.originalDirection.equals((Object)Direction.NORTH)) {
            int n = this.originalDirection.inDegrees();
            if (n >= 180) {
                graphics2D.scale(-1.0, 1.0);
            }
            graphics2D.rotate(-Math.toRadians(n));
        }
        graphics2D.scale(1.0 / (double)this.icon.getIconWidth(), 1.0 / (double)this.icon.getIconHeight());
        Color color = fish.color();
        Image image = (Image)this.tintedVersions.get(color);
        if (image == null) {
            FilteredImageSource filteredImageSource = new FilteredImageSource(this.originalImage.getSource(), new TintFilter(color));
            image = component.createImage(filteredImageSource);
            this.tintedVersions.put(color, image);
        }
        this.icon.setImage(image);
        this.icon.paintIcon(component, graphics2D, -this.icon.getIconWidth() / 2, -this.icon.getIconHeight() / 2);
    }

    private static class TintFilter
    extends RGBImageFilter {
        private int tintR;
        private int tintG;
        private int tintB;

        public TintFilter(Color color) {
            this.canFilterIndexColorModel = true;
            int n = color.getRGB();
            this.tintR = n >> 16 & 0xFF;
            this.tintG = n >> 8 & 0xFF;
            this.tintB = n & 0xFF;
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 >> 24 & 0xFF;
            int n5 = n3 >> 16 & 0xFF;
            int n6 = n3 >> 8 & 0xFF;
            int n7 = n3 & 0xFF;
            int n8 = (int)(0.2989 * (double)n5 + 0.5866 * (double)n6 + 0.1144 * (double)n7);
            double d = Math.abs((double)(n8 - 128) / 128.0);
            int n9 = n8 < 128 ? 0 : 255;
            n5 = this.tintR + (int)((double)(n9 - this.tintR) * d);
            n6 = this.tintG + (int)((double)(n9 - this.tintG) * d);
            n7 = this.tintB + (int)((double)(n9 - this.tintB) * d);
            return n4 << 24 | n5 << 16 | n6 << 8 | n7;
        }
    }
}

