/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public class FishDisplay
extends AbstractFishDisplay {
    private static final double BODY_WIDTH = 0.55;
    private static final double BODY_LENGTH = 0.75;
    private static final double TAIL_WIDTH = 0.5;
    private static final double TAIL_LENGTH = 0.4;
    private static final double EYE_SIZE = 0.08;
    private static final int GRADIENT_SIZE = 50;
    private static final AffineTransform ATX = AffineTransform.getScaleInstance(50.0, 50.0);
    private Shape bodyAndTail;
    private Shape eye1;
    private Shape eye2;

    public FishDisplay() {
        this.buildPaths(0.55, 0.75, 0.5, 0.4, 0.08);
    }

    protected void buildPaths(double d, double d2, double d3, double d4, double d5) {
        float f = (float)(d2 + d4 / 3.0) / 2.0f;
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d / 2.0, -f, d, d2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-((float)d3) / 2.0f, f);
        generalPath.lineTo(0.0f, f - (float)d4);
        generalPath.lineTo((float)d3 / 2.0f, f);
        generalPath.closePath();
        generalPath.append(double_, false);
        this.bodyAndTail = generalPath;
        this.eye1 = new Ellipse2D.Double(-d / 4.0, (double)(-f) + d2 / 4.0, d5, d5);
        this.eye2 = new Ellipse2D.Double(d / 4.0 - d5, (double)(-f) + d2 / 4.0, d5, d5);
    }

    public void draw(Fish fish, Component component, Graphics2D graphics2D) {
        Color color = fish.color();
        graphics2D.setPaint(color.darker());
        graphics2D.draw(this.bodyAndTail);
        graphics2D.scale(0.02, 0.02);
        graphics2D.setPaint(new GradientPaint(-12.0f, -25.0f, Color.white, 12.0f, 12.0f, color));
        graphics2D.fill(ATX.createTransformedShape(this.bodyAndTail));
        graphics2D.scale(50.0, 50.0);
        graphics2D.setPaint(Color.black);
        graphics2D.fill(this.eye1);
        graphics2D.fill(this.eye2);
    }
}

