/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;

public class EnvironmentController {
    public static final int DONT_RESET_SEED = 0;
    public static final int FIXED_SEED = 1;
    public static final int PROMPT_SEED = 2;
    private static final Direction START_FACING = Direction.EAST;
    private Environment env;
    private int seed;
    private int seedOption;
    private MBSGUIFrame parentFrame;
    private MBSDisplay display;
    private SimulationController simControl;
    private EnvFileChooser fileChooser;
    private CreateEnvDialog createEnvDialog;
    private FishToolbar toolbar;

    public EnvironmentController(MBSGUIFrame mBSGUIFrame, MBSDisplay mBSDisplay, SimulationController simulationController) {
        this.display = mBSDisplay;
        this.parentFrame = mBSGUIFrame;
        this.simControl = simulationController;
        this.toolbar = new FishToolbar();
        this.setFishToolbarVisible(false);
        this.display.addMouseListener(new 1());
    }

    public FishToolbar controlPanel() {
        return this.toolbar;
    }

    private void setEnv(Environment environment) {
        this.env = environment;
        this.display.setEnv(this.env);
        this.simControl.setEnv(this.env, this);
        this.parentFrame.setEnvMenuItemsEnabled(true);
    }

    public void createNewEnv() {
        Environment environment;
        if (this.createEnvDialog == null) {
            this.createEnvDialog = new CreateEnvDialog(this.parentFrame);
        }
        if ((environment = this.createEnvDialog.showDialog()) != null) {
            this.resetSeedIfNeeded();
            this.setFishToolbarVisible(true);
            this.setEnv(environment);
        }
    }

    public void editEnv() {
        this.simControl.stop();
        this.setFishToolbarVisible(true);
    }

    public void openFile() {
        Environment environment;
        if (this.fileChooser == null) {
            this.fileChooser = new EnvFileChooser();
        }
        if (this.fileChooser.showOpenDialog(this.parentFrame) != 0) {
            return;
        }
        try {
            MBSDataFileHandler mBSDataFileHandler = new MBSDataFileHandler(this.fileChooser.getSelectedFile());
            this.resetSeedIfNeeded();
            environment = mBSDataFileHandler.readMBSEnv(this.fileChooser.boundedClass(), this.fileChooser.unboundedClass());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.parentFrame, "Unable to read environment from file.\nReason: " + exception, "Error reading file", 0);
            return;
        }
        this.setFishToolbarVisible(false);
        this.setEnv(environment);
    }

    public void saveFile() {
        if (this.fileChooser == null) {
            this.fileChooser = new EnvFileChooser();
        }
        this.simControl.stop();
        if (this.fileChooser.showSaveDialog(this.parentFrame) != 0) {
            return;
        }
        try {
            MBSDataFileHandler mBSDataFileHandler = new MBSDataFileHandler(this.fileChooser.getSelectedFile());
            mBSDataFileHandler.writeMBSEnv(this.env);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.parentFrame, "Unable to save environment to file.\nReason: " + exception, "Error saving file", 0);
        }
    }

    public int setSeedOption(int n) {
        if (n == 1 && !this.promptUserForSeed()) {
            return this.seedOption;
        }
        this.seedOption = n;
        if (this.seedOption == 2) {
            JOptionPane.showMessageDialog(this.parentFrame, "You will be prompted for a new seed when opening or creating an environment.", "Prompt for seed", 1);
        }
        return this.seedOption;
    }

    private void resetSeedIfNeeded() {
        switch (this.seedOption) {
            case 2: {
                this.promptUserForSeed();
            }
            case 1: {
                RandNumGenerator.getInstance().setSeed(this.seed);
            }
        }
    }

    private boolean promptUserForSeed() {
        int n = this.seed == 0 ? 17 : this.seed;
        String string = (String)JOptionPane.showInputDialog(this.parentFrame, "Enter seed for random number generator:", "Input", 3, null, null, String.valueOf(n));
        if (string != null) {
            try {
                this.seed = Integer.parseInt(string.trim());
                return true;
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        return false;
    }

    public void setFishToolbarVisible(boolean bl) {
        if (this.toolbar.isVisible() != bl) {
            this.toolbar.setVisible(bl);
            Dimension dimension = this.parentFrame.getSize();
            Dimension dimension2 = this.toolbar.getOrientation() == 0 ? new Dimension(0, (bl ? 1 : -1) * this.toolbar.getPreferredSize().height) : new Dimension((bl ? 1 : -1) * this.toolbar.getPreferredSize().width, 0);
            ((Component)this.parentFrame).setSize(new Dimension(dimension.width + dimension2.width, dimension.height + dimension2.height));
            this.parentFrame.validate();
        }
    }

    private void createFishForEvent(MouseEvent mouseEvent) {
        Location location = this.display.locationForPoint(mouseEvent.getPoint());
        if (location != null && this.toolbar.isVisible()) {
            Fish fish = (Fish)this.env.objectAt(location);
            Class clazz = this.toolbar.currentFishClass();
            if (fish == null || !fish.getClass().equals(clazz)) {
                if (fish != null) {
                    this.env.remove((Locatable)fish);
                }
                this.constructFish(clazz, this.env, location, START_FACING, this.toolbar.currentColor());
            } else {
                int n = 360 / this.env.numAdjacentNeighbors();
                Direction direction = fish.direction().toRight(n);
                if (direction.equals((Object)START_FACING)) {
                    this.env.remove((Locatable)fish);
                } else {
                    fish.changeDirection(direction);
                }
            }
            this.display.repaint();
        }
    }

    private void constructFish(Class clazz, Environment environment, Location location, Direction direction, Color color) {
        try {
            if (MBSFactory.hasFourArgCtor((Class)clazz)) {
                MBSFactory.constructEnvObject((Class)clazz, (Environment)environment, (Location)location, (Direction)direction, (Color)color);
            } else {
                MBSFactory.constructEnvObject((Class)clazz, (Environment)environment, (Location)location, (Direction)direction);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.parentFrame, "Cannot construct " + clazz.getName() + " with Environment, Location, Direction, and Color parameters.\n" + "Reason: " + exception, "Error constructing fish", 0);
        }
    }

    private final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            EnvironmentController.this.createFishForEvent(mouseEvent);
        }

        /* synthetic */ 1() {
        }
    }
}

