/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class EnvFileChooser
extends JFileChooser {
    private static final String ENV_EXT = ".dat";
    private JPanel openAccessory;
    private JComboBox boundedChooser;
    private JComboBox unboundedChooser;
    private Class defaultBounded = class$BoundedEnv != null ? class$BoundedEnv : (class$BoundedEnv = EnvFileChooser.class$("BoundedEnv"));
    private Class defaultUnbounded = class$UnboundedEnv != null ? class$UnboundedEnv : (class$UnboundedEnv = EnvFileChooser.class$("UnboundedEnv"));
    static /* synthetic */ Class class$BoundedEnv;
    static /* synthetic */ Class class$UnboundedEnv;

    public EnvFileChooser() {
        super(new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "DataFiles"));
        this.setFileFilter(new 1());
        this.setFileSelectionMode(0);
        this.makeOpenAccessory();
    }

    public int showOpenDialog(Component component) {
        this.setDialogTitle("Open environment file");
        this.setAccessory(this.openAccessory);
        this.rescanCurrentDirectory();
        return super.showOpenDialog(component);
    }

    public int showSaveDialog(Component component) {
        this.setDialogTitle("Save environment file");
        this.setAccessory(null);
        this.rescanCurrentDirectory();
        return super.showSaveDialog(component);
    }

    public void approveSelection() {
        if (this.getDialogType() == 1) {
            File file = this.getSelectedFile();
            if (!file.getName().endsWith(ENV_EXT)) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ENV_EXT);
                this.setSelectedFile(file);
            }
            if (file.exists() && JOptionPane.showConfirmDialog(this, "File " + file.getName() + " exists. Overwrite?", "Confirm overwrite", 2) != 0) {
                return;
            }
        }
        super.approveSelection();
    }

    public Class boundedClass() {
        if (this.boundedChooser == null) {
            return this.defaultBounded;
        }
        return ((CreateEnvDialog.EnvChoice)this.boundedChooser.getSelectedItem()).envClass();
    }

    public Class unboundedClass() {
        if (this.unboundedChooser == null) {
            return this.defaultUnbounded;
        }
        return ((CreateEnvDialog.EnvChoice)this.unboundedChooser.getSelectedItem()).envClass();
    }

    private void makeOpenAccessory() {
        this.openAccessory = new JPanel();
        this.openAccessory.setLayout(new BoxLayout(this.openAccessory, 1));
        this.openAccessory.setBorder(BorderFactory.createEmptyBorder(20, 5, 5, 0));
        Set set = MBSFactory.boundedEnvClasses();
        if (set.size() == 1) {
            this.defaultBounded = (Class)set.iterator().next();
        } else if (set.size() > 1) {
            this.openAccessory.add(new JLabel("Class for bounded:"));
            this.boundedChooser = new JComboBox();
            CreateEnvDialog.EnvChoice.addChoicesFromFactory(this.boundedChooser, true);
            this.boundedChooser.setAlignmentX(0.0f);
            this.openAccessory.add(this.boundedChooser);
            this.openAccessory.add(Box.createRigidArea(new Dimension(5, 5)));
        }
        set = MBSFactory.unboundedEnvClasses();
        if (set.size() == 1) {
            this.defaultUnbounded = (Class)set.iterator().next();
        } else if (set.size() > 1) {
            this.openAccessory.add(new JLabel("Class for unbounded:"));
            this.unboundedChooser = new JComboBox();
            CreateEnvDialog.EnvChoice.addChoicesFromFactory(this.unboundedChooser, false);
            this.unboundedChooser.setAlignmentX(0.0f);
            this.openAccessory.add(this.unboundedChooser);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class 1
    extends FileFilter {
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(EnvFileChooser.ENV_EXT) || file.isDirectory();
        }

        public String getDescription() {
            return "MBS fish data files (*.dat)";
        }

        /* synthetic */ 1() {
        }
    }
}

