/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CreateEnvDialog {
    private EnvChoice envChoice;
    private int numRows;
    private int numCols;
    private JTextField rowField;
    private JTextField colField;
    private JComboBox envChooser;
    private JPanel dimPanel;
    private JButton[] optButtons;
    private JDialog dialog;

    public CreateEnvDialog(JFrame jFrame) {
        this.dialog = new JDialog(jFrame, "Create new environment", true);
        this.dialog.setContentPane(this.makeOptionsPanel());
        this.dialog.pack();
        this.dialog.setResizable(false);
    }

    public Environment showDialog() {
        this.envChoice = null;
        this.rowField.requestFocus();
        Container container = this.dialog.getParent();
        ((Component)this.dialog).setLocation(container.getX() + container.getWidth() / 2 - this.dialog.getSize().width / 2, container.getY() + container.getHeight() / 2 - this.dialog.getSize().height / 2);
        this.dialog.show();
        if (this.envChoice == null) {
            return null;
        }
        try {
            if (this.envChoice.isBounded()) {
                return MBSFactory.constructEnv((Class)this.envChoice.envClass(), (int)this.numRows, (int)this.numCols);
            }
            return MBSFactory.constructEnv((Class)this.envChoice.envClass());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.dialog.getParent(), "Unable to create new environment.\nReason: " + exception, "Error creating environment", 0);
            return null;
        }
    }

    private void envChosen() {
        this.dimPanel.setVisible(((EnvChoice)this.envChooser.getSelectedItem()).isBounded());
        this.optButtons[0].requestFocus();
    }

    private void cancelClicked() {
        this.envChoice = null;
        ((Component)this.dialog).setVisible(false);
    }

    private void okClicked() {
        try {
            this.envChoice = (EnvChoice)this.envChooser.getSelectedItem();
            if (this.envChoice.isBounded()) {
                this.rowField.requestFocus();
                this.numRows = Integer.parseInt(this.rowField.getText().trim());
                this.colField.requestFocus();
                this.numCols = Integer.parseInt(this.colField.getText().trim());
                if (this.numRows < 0 || this.numCols < 0) {
                    throw new NumberFormatException();
                }
            }
            ((Component)this.dialog).setVisible(false);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.dialog, "Environment dimensions must be positive integers!", "Error creating environment", 0);
        }
    }

    private JOptionPane makeOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("Choose environment type: ");
        jPanel.add(jLabel);
        jLabel.setAlignmentX(0.5f);
        this.envChooser = new JComboBox();
        EnvChoice.addChoicesFromFactory(this.envChooser);
        this.envChooser.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        this.envChooser.addActionListener(new 1());
        jPanel.add(this.envChooser);
        this.dimPanel = new JPanel();
        this.dimPanel.setLayout(new BoxLayout(this.dimPanel, 0));
        this.dimPanel.add(new JLabel("rows: "));
        this.rowField = new JTextField("10");
        this.dimPanel.add(this.rowField);
        this.dimPanel.add(new JLabel("  cols: "));
        this.colField = new JTextField("10");
        this.dimPanel.add(this.colField);
        jPanel.add(this.dimPanel);
        JOptionPane jOptionPane = new JOptionPane(jPanel, 3);
        this.optButtons = new JButton[]{new JButton("Create"), new JButton("Cancel")};
        jOptionPane.setOptions(this.optButtons);
        jOptionPane.setInitialValue(this.optButtons[0]);
        this.optButtons[1].addActionListener(new 2());
        this.optButtons[0].addActionListener(new 3());
        return jOptionPane;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CreateEnvDialog.this.envChosen();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CreateEnvDialog.this.cancelClicked();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CreateEnvDialog.this.okClicked();
        }

        /* synthetic */ 3() {
        }
    }

    static class EnvChoice {
        private Class cls;
        private boolean isBounded;

        public EnvChoice(Class clazz, boolean bl) {
            this.cls = clazz;
            this.isBounded = bl;
        }

        public boolean isBounded() {
            return this.isBounded;
        }

        public Class envClass() {
            return this.cls;
        }

        public String toString() {
            return this.cls.getName();
        }

        public static void addChoicesFromFactory(JComboBox jComboBox) {
            EnvChoice.addChoicesFromFactory(jComboBox, true);
            EnvChoice.addChoicesFromFactory(jComboBox, false);
        }

        public static void addChoicesFromFactory(JComboBox jComboBox, boolean bl) {
            Iterator iterator = bl ? MBSFactory.boundedEnvClasses().iterator() : MBSFactory.unboundedEnvClasses().iterator();
            while (iterator.hasNext()) {
                jComboBox.addItem(new EnvChoice((Class)iterator.next(), bl));
            }
        }
    }
}

