/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Random;

public abstract class SquareEnvironment
implements Environment {
    private static final int NUM_SIDES_IN_SQUARE = 4;
    private boolean includeDiagonals;

    public SquareEnvironment() {
        this.includeDiagonals = false;
    }

    public SquareEnvironment(boolean includeDiagonalNeighbors) {
        this.includeDiagonals = includeDiagonalNeighbors;
    }

    public int numCellSides() {
        return 4;
    }

    public int numAdjacentNeighbors() {
        return this.includeDiagonals ? 8 : 4;
    }

    public Direction randomDirection() {
        Random randNumGen = RandNumGenerator.getInstance();
        int randNum = randNumGen.nextInt(this.numAdjacentNeighbors());
        return new Direction(randNum * 360 / this.numAdjacentNeighbors());
    }

    public Direction getDirection(Location fromLoc, Location toLoc) {
        if (fromLoc.equals(toLoc)) {
            return Direction.NORTH;
        }
        int rowDifference = fromLoc.row() - toLoc.row();
        int colDifference = toLoc.col() - fromLoc.col();
        double inRads = Math.atan2(rowDifference, colDifference);
        double angle = 90.0 - Math.toDegrees(inRads);
        Direction d = new Direction((int)angle);
        return d.roundedDir(this.numAdjacentNeighbors(), Direction.NORTH);
    }

    public Location getNeighbor(Location fromLoc, Direction compassDir) {
        Direction roundedDir = compassDir.roundedDir(this.numAdjacentNeighbors(), Direction.NORTH);
        int adjustedDegrees = 90 - roundedDir.inDegrees();
        double inRads = Math.toRadians(adjustedDegrees);
        int colDelta = (int)(Math.cos(inRads) * Math.sqrt(2.0));
        int rowDelta = -((int)(Math.sin(inRads) * Math.sqrt(2.0)));
        return new Location(fromLoc.row() + rowDelta, fromLoc.col() + colDelta);
    }

    public ArrayList neighborsOf(Location ofLoc) {
        ArrayList<Location> nbrs = new ArrayList<Location>();
        Direction d = Direction.NORTH;
        int i = 0;
        while (i < this.numAdjacentNeighbors()) {
            Location neighbor = this.getNeighbor(ofLoc, d);
            if (this.isValid(neighbor)) {
                nbrs.add(neighbor);
            }
            d = d.toRight(360 / this.numAdjacentNeighbors());
            ++i;
        }
        return nbrs;
    }

    public abstract Locatable[] allObjects();

    public abstract int numRows();

    public abstract void recordMove(Locatable var1, Location var2);

    public abstract boolean isValid(Location var1);

    public abstract Locatable objectAt(Location var1);

    public abstract int numObjects();

    public abstract void remove(Locatable var1);

    public abstract void add(Locatable var1);

    public abstract int numCols();

    public abstract boolean isEmpty(Location var1);
}

