/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class MBSFactory {
    private static Comparator classCmp = new 1();
    private static Set envObjectClasses = new TreeSet(classCmp);
    private static Set boundedEnvClasses = new TreeSet(classCmp);
    private static Set unboundedEnvClasses = new TreeSet(classCmp);
    private static final Class[] TWO_ARG_TYPES = new Class[]{class$Environment != null ? class$Environment : (class$Environment = MBSFactory.class$("Environment")), class$Location != null ? class$Location : (class$Location = MBSFactory.class$("Location"))};
    private static final Class[] THREE_ARG_TYPES = new Class[]{class$Environment != null ? class$Environment : (class$Environment = MBSFactory.class$("Environment")), class$Location != null ? class$Location : (class$Location = MBSFactory.class$("Location")), class$Direction != null ? class$Direction : (class$Direction = MBSFactory.class$("Direction"))};
    private static final Class[] FOUR_ARG_TYPES = new Class[]{class$Environment != null ? class$Environment : (class$Environment = MBSFactory.class$("Environment")), class$Location != null ? class$Location : (class$Location = MBSFactory.class$("Location")), class$Direction != null ? class$Direction : (class$Direction = MBSFactory.class$("Direction")), class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = MBSFactory.class$("java.awt.Color"))};
    private static final Class[] BOUNDED_ARGS = new Class[]{Integer.TYPE, Integer.TYPE};
    private static final Class[] UNBOUNDED_ARGS = null;
    static /* synthetic */ Class class$Environment;
    static /* synthetic */ Class class$Location;
    static /* synthetic */ Class class$Direction;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$Locatable;

    public static Object constructObject(Class cls, Class[] parameterTypes, Object[] parameters) {
        Object newObject = null;
        try {
            if (parameterTypes == null || parameters == null) {
                newObject = cls.newInstance();
            } else {
                Constructor objCons = cls.getConstructor(parameterTypes);
                newObject = objCons.newInstance(parameters);
            }
            return newObject;
        }
        catch (Exception e) {
            throw new MBSException("Cannot construct " + cls.getName() + " object due to " + e);
        }
    }

    public static Object constructEnvObject(Class cls, Environment env, Location loc) {
        Object[] parameters = new Object[]{env, loc};
        return MBSFactory.constructObject(cls, TWO_ARG_TYPES, parameters);
    }

    public static Object constructEnvObject(Class cls, Environment env, Location loc, Direction dir) {
        Object[] parameters = new Object[]{env, loc, dir};
        return MBSFactory.constructObject(cls, THREE_ARG_TYPES, parameters);
    }

    public static Object constructEnvObject(Class cls, Environment env, Location loc, Direction dir, Color color) {
        Object[] parameters = new Object[]{env, loc, dir, color};
        return MBSFactory.constructObject(cls, FOUR_ARG_TYPES, parameters);
    }

    public static Environment constructEnv(Class cls) {
        return (Environment)MBSFactory.constructObject(cls, null, null);
    }

    public static Environment constructEnv(Class cls, int numRows, int numCols) {
        Object[] parameters = new Object[]{new Integer(numRows), new Integer(numCols)};
        return (Environment)MBSFactory.constructObject(cls, BOUNDED_ARGS, parameters);
    }

    public static Set envObjectClasses() {
        return envObjectClasses;
    }

    public static Set boundedEnvClasses() {
        return boundedEnvClasses;
    }

    public static Set unboundedEnvClasses() {
        return unboundedEnvClasses;
    }

    protected static void addClassesToFactory(String[] classNames, String whichCategory) {
        int i = 0;
        while (i < classNames.length) {
            String errStart = "Discarding " + whichCategory + " choice \"" + classNames[i] + "\" because ";
            try {
                Class<?> cls = Class.forName(classNames[i]);
                if (whichCategory.equals("bounded environment")) {
                    if (MBSFactory.isValidEnvClass(cls, BOUNDED_ARGS)) {
                        boundedEnvClasses.add(cls);
                    }
                } else if (whichCategory.equals("unbounded environment")) {
                    if (MBSFactory.isValidEnvClass(cls, null)) {
                        unboundedEnvClasses.add(cls);
                    }
                } else {
                    envObjectClasses.add(cls);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(String.valueOf(errStart) + "no class found with that name.");
            }
            catch (ClassCastException e) {
                System.err.println(String.valueOf(errStart) + e.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println(String.valueOf(errStart) + "it doesn't have the proper constructor.");
            }
            ++i;
        }
    }

    public static void addEnvObjClassNames(String[] classNames) {
        MBSFactory.addClassesToFactory(classNames, "environment object");
    }

    public static void addBoundedEnvClassNames(String[] classNames) {
        MBSFactory.addClassesToFactory(classNames, "bounded environment");
    }

    public static void addUnboundedEnvClassNames(String[] classNames) {
        MBSFactory.addClassesToFactory(classNames, "unbounded environment");
    }

    public static boolean isValidEnvClass(Class cls, Class[] ctorParameters) throws NoSuchMethodException {
        return MBSFactory.hasCorrectCtor(cls, class$Environment != null ? class$Environment : (class$Environment = MBSFactory.class$("Environment")), ctorParameters);
    }

    public static boolean isValidEnvObjectClass(Class cls, Class[] ctorParameters) throws NoSuchMethodException {
        return MBSFactory.hasCorrectCtor(cls, class$Locatable != null ? class$Locatable : (class$Locatable = MBSFactory.class$("Locatable")), ctorParameters);
    }

    protected static boolean hasCorrectCtor(Class cls, Class requiredCls, Class[] ctorParameters) throws NoSuchMethodException {
        if (!requiredCls.isAssignableFrom(cls)) {
            throw new ClassCastException("not compatible with " + requiredCls + ".");
        }
        Constructor ctor = cls.getConstructor(ctorParameters);
        return true;
    }

    public static boolean hasFourArgCtor(Class cls) {
        try {
            return MBSFactory.isValidEnvObjectClass(cls, FOUR_ARG_TYPES);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }

        /* synthetic */ 1() {
        }
    }
}

