/*
 * Decompiled with CFR 0.152.
 */
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class MBSDataFileHandler {
    private File myFile;
    private LineNumberReader inputReader;
    private StringTokenizer tokenizer;

    public MBSDataFileHandler(File file) {
        this.myFile = file;
    }

    public Environment readMBSEnv(Class boundedEnvClass, Class unboundedEnvClass) throws FileNotFoundException {
        this.inputReader = new LineNumberReader(new FileReader(this.myFile));
        Environment env = this.buildEnv(boundedEnvClass, unboundedEnvClass);
        while (this.readEnvObject(env)) {
        }
        return env;
    }

    private Environment buildEnv(Class boundedEnvClass, Class unboundedEnvClass) {
        String envType;
        try {
            envType = this.readString();
        }
        catch (Exception exception) {
            throw new MBSException("Error reading environment type (line " + this.inputReader.getLineNumber() + ")");
        }
        if (envType.equals("bounded")) {
            int envCols;
            int envRows;
            try {
                envRows = this.readInt();
                envCols = this.readInt();
            }
            catch (Exception exception) {
                throw new MBSException("Error reading environment dimensions (line " + this.inputReader.getLineNumber() + ")");
            }
            if (envRows <= 0 || envCols <= 0) {
                throw new MBSException("Environment dimensions must be positive (line " + this.inputReader.getLineNumber() + ")");
            }
            return MBSFactory.constructEnv(boundedEnvClass, envRows, envCols);
        }
        if (envType.equals("unbounded")) {
            return MBSFactory.constructEnv(unboundedEnvClass);
        }
        throw new MBSException("File must begin with bounded or unbounded (line " + this.inputReader.getLineNumber() + ")");
    }

    private boolean readEnvObject(Environment env) {
        String className = null;
        try {
            className = this.readString();
            if (className == null) {
                this.inputReader.close();
                return false;
            }
            Class<?> cls = Class.forName(className);
            Location loc = this.readLocation(env);
            Direction dir = this.readDirection();
            MBSFactory.constructEnvObject(cls, env, loc, dir);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MBSException("Cannot find class named " + className + " (line " + this.inputReader.getLineNumber() + ")");
        }
        catch (IOException iOException) {
            throw new MBSException("Error reading environment object (line " + this.inputReader.getLineNumber() + ")");
        }
        catch (MBSException mBSException) {
            throw new MBSException("Error constructing object (line " + this.inputReader.getLineNumber() + ")");
        }
        return true;
    }

    private Location readLocation(Environment env) {
        int col;
        int row;
        try {
            row = this.readInt();
            col = this.readInt();
        }
        catch (Exception exception) {
            throw new MBSException("Error reading location (line " + this.inputReader.getLineNumber() + ")");
        }
        Location loc = new Location(row, col);
        if (env.isValid(loc)) {
            return loc;
        }
        throw new MBSException("Location " + loc + " is not valid in this environment (line " + this.inputReader.getLineNumber() + ")");
    }

    private Direction readDirection() throws IOException {
        String dirName = null;
        Direction dir = null;
        try {
            dirName = this.readString();
            int degrees = Integer.parseInt(dirName);
            dir = new Direction(degrees);
        }
        catch (Exception exception) {
            try {
                dir = new Direction(dirName);
            }
            catch (Exception exception2) {
                throw new MBSException("Error reading direction (line " + this.inputReader.getLineNumber() + ")");
            }
        }
        return dir;
    }

    private String readString() throws IOException {
        while (this.tokenizer == null || !this.tokenizer.hasMoreTokens()) {
            String line = this.inputReader.readLine();
            if (line == null) {
                return null;
            }
            this.tokenizer = new StringTokenizer(line);
        }
        return this.tokenizer.nextToken();
    }

    private int readInt() throws IOException {
        String token = this.readString();
        if (token == null) {
            throw new EOFException();
        }
        return Integer.parseInt(token);
    }

    public void writeMBSEnv(Environment env) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(this.myFile));
        if (env.numRows() == -1 || env.numCols() == -1) {
            out.println("unbounded");
        } else {
            out.println("bounded " + env.numRows() + " " + env.numCols());
        }
        Locatable[] objList = env.allObjects();
        int index = 0;
        while (index < objList.length) {
            Fish fish = (Fish)objList[index];
            String className = fish.getClass().getName();
            int row = fish.location().row();
            int col = fish.location().col();
            String dir = fish.direction().toString();
            out.println(String.valueOf(className) + " " + row + " " + col + " " + dir);
            ++index;
        }
        out.close();
    }
}

