/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class Direction {
    public static final Direction NORTH = new Direction(0);
    public static final Direction NORTHEAST = new Direction(45);
    public static final Direction EAST = new Direction(90);
    public static final Direction SOUTHEAST = new Direction(135);
    public static final Direction SOUTH = new Direction(180);
    public static final Direction SOUTHWEST = new Direction(225);
    public static final Direction WEST = new Direction(270);
    public static final Direction NORTHWEST = new Direction(315);
    public static final int FULL_CIRCLE = 360;
    private static final String[] dirNames = new String[]{"North", "Northeast", "East", "Southeast", "South", "Southwest", "West", "Northwest"};
    private int dirInDegrees;

    public Direction() {
        this.dirInDegrees = 0;
    }

    public Direction(int degrees) {
        this.dirInDegrees = degrees % 360;
        if (this.dirInDegrees < 0) {
            this.dirInDegrees += 360;
        }
    }

    public Direction(String str) {
        int regionWidth = 360 / dirNames.length;
        int k = 0;
        while (k < dirNames.length) {
            if (str.equalsIgnoreCase(dirNames[k])) {
                this.dirInDegrees = k * regionWidth;
                return;
            }
            ++k;
        }
        throw new IllegalArgumentException("Illegal direction specified: \"" + str + "\"");
    }

    public int inDegrees() {
        return this.dirInDegrees;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Direction)) {
            return false;
        }
        Direction d = (Direction)other;
        return this.inDegrees() == d.inDegrees();
    }

    public int hashCode() {
        return this.inDegrees();
    }

    public Direction toRight() {
        return new Direction(this.dirInDegrees + 90);
    }

    public Direction toRight(int deg) {
        return new Direction(this.dirInDegrees + deg);
    }

    public Direction toLeft() {
        return new Direction(this.dirInDegrees - 90);
    }

    public Direction toLeft(int deg) {
        return new Direction(this.dirInDegrees - deg);
    }

    public Direction reverse() {
        return new Direction(this.dirInDegrees + 180);
    }

    public String toString() {
        int regionWidth = 360 / dirNames.length;
        if (this.dirInDegrees % regionWidth == 0) {
            return dirNames[this.dirInDegrees / regionWidth];
        }
        return String.valueOf(this.dirInDegrees) + " degrees";
    }

    public Direction roundedDir(int numDirections, Direction startingDir) {
        int degreesFromStartingDir = this.dirInDegrees - startingDir.inDegrees();
        int regionWidth = 360 / numDirections;
        int numRegions = Math.round((float)degreesFromStartingDir / (float)regionWidth);
        return startingDir.toRight(numRegions * regionWidth);
    }

    public static Direction randomDirection() {
        Random randNumGen = RandNumGenerator.getInstance();
        return new Direction(randNumGen.nextInt(360));
    }
}

