/**
 * File: InvasionDialog.java
 * Author: J. Tang
 *
 * This file contains the invasion user interface.
 *
 * DO NOT edit this file.
 * DO NOT submit this file.
 *
 */
package proj4;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

public class InvasionDialog extends JDialog {
    public InvasionDialog(GameInterface g) {
	game = g;

	setTitle("Ants Versus Zombies");
	addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {
		    System.exit(0);
		}
	    });

	JLabel title = new JLabel("Zombie Invasion", SwingConstants.CENTER);
	title.setFont(new Font("SansSerif", Font.BOLD, 24));
	title.setForeground(Color.RED);
	add(title, BorderLayout.NORTH);

	JPanel p = new JPanel(new GridBagLayout());
	add(p, BorderLayout.CENTER);
	GridBagConstraints c = new GridBagConstraints();

	JLabel roundLabel = new JLabel("Round: ", SwingConstants.RIGHT);
	roundLabel.setFont(new Font("SansSerif", Font.PLAIN, 16));
	c.gridx = 0;
	c.gridy = 0;
	c.weightx = 1;
	c.weighty = 0;
	c.ipadx = 4;
	c.ipady = 20;
	c.anchor = GridBagConstraints.EAST;
	p.add(roundLabel, c);

	JLabel roundNum = new JLabel("" + game.getRoundNumber(), SwingConstants.LEFT);
	roundNum.setFont(new Font("SansSerif", Font.PLAIN, 16));
	c.gridx = 1;
	c.anchor = GridBagConstraints.WEST;
	p.add(roundNum, c);

	JLabel foodLabel = new JLabel("Food: ", SwingConstants.RIGHT);
	foodLabel.setFont(new Font("SansSerif", Font.PLAIN, 16));
	c.gridx = 2;
	c.anchor = GridBagConstraints.EAST;
	p.add(foodLabel, c);

	foodNum = new JLabel("" + game.getFood(), SwingConstants.LEFT);
	foodNum.setFont(new Font("SansSerif", Font.PLAIN, 16));
	c.gridx = 3;
	c.anchor = GridBagConstraints.WEST;
	p.add(foodNum, c);

	colony = new JTextArea(10, 20);
	colony.setEditable(false);
	colony.setText(game.getColonyDesc());
	JScrollPane sp = new JScrollPane(colony);
	sp.setBorder(new TitledBorder("Colony"));
	c.gridx = 0;
	c.gridy = 1;
	c.weightx = 1;
	c.weighty = 1;
	c.ipadx = 10;
	c.ipady = 10;
	c.fill = GridBagConstraints.BOTH;
	c.anchor = GridBagConstraints.CENTER;
	p.add(sp, c);

	JButton b = new JButton("FIGHT!");
	b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    game.nextFight();
		    colony.setText(game.getColonyDesc());
		    horde.setText(game.getHordeDesc());
		    foodNum.setText("" + game.getFood());
		    if (game.isInvasionOver()) {
			JOptionPane.showMessageDialog(InvasionDialog.this, "Invasion Over", "Ants Versus Zombies", JOptionPane.INFORMATION_MESSAGE);
			dispose();
		    }
		}
	    });
	c.gridx = 1;
	c.weightx = 0;
	c.weighty = 0;
	c.ipadx = 20;
	c.gridwidth = 2;
	c.fill = GridBagConstraints.NONE;
	p.add(b, c);

	horde = new JTextArea(10, 20);
	horde.setEditable(false);
	horde.setText(game.getHordeDesc());
	sp = new JScrollPane(horde);
	sp.setBorder(new TitledBorder("Invading Horde"));
	c.gridx = 3;
	c.weightx = 1;
	c.weighty = 1;
	c.ipadx = 10;
	c.gridwidth = 1;
	c.fill = GridBagConstraints.BOTH;
	p.add(sp, c);

	setModal(true);
	pack();
	setVisible(true);
    }

    private final GameInterface game;
    private final JTextArea colony, horde;
    private final JLabel foodNum;
}